package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.TipoApertura;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * ComunicacionAperturaCustomDaoImpl generated by UDA, 26-dic-2016 13:08:26.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class ComunicacionAperturaCustomDaoImpl extends
		ComunicacionAperturaDaoImpl implements ComunicacionAperturaCustomDao {

	private static final String QUERY_SELECT_COMUNICACION_APERTURA = " SELECT ANOAPE,APDOANX,ASGINS,ASGOSL,CANALEVAL,CANALPLAN,  CLASCTR,  CNAECTR,  CNAECTR93,  CNAEEMP,  "
			+ "CNAEEMP93,  CODCTR,  CODENTIAT,  CODOBRA,  CPOCTR,  CPOEMP,  DESCMAQ,  DESCOBR,  DESTRAB,  DIGSS,  DIRCTR,  DIREMP,  DMUNEMP,  "
			+ "DOCCORRECTA, EMAILCTR,  ENTIAT,  ESTADOCIER,  ESTADO,  EVALPRES,  FAXCTR,  FECALT,  FECIER,  FECINI,  FECINSP,  FECMOD,  FECPRE,  FECREQ,  FECSUB,  "
			+ "FINFINSP,  FINFOSL, FORPRE,  FVISINS,  FVISOSL,  IDAPE,  INDANX,  INDOBRA,  LOCCTR,  LOTEMNT,  MODPRE,  MUNCTR, DESMUNCTR,  MUNEMP, DESMUNEMP,  NOMCTR,  NOMEMP,  NUEVA,  "
			+ "NUMAPE,  NUMCNT,  NUMDOCREPRESENTANTE,NOMREPRESENTANTE,TIPDOCREPRESENTANTE,  NUMDOC,  NUMSS,  PLANPRES,  PLANSEG,  POTEN,  PROYTEC,  PRVCTR, DESPRVCTR,  PAISEMP, PRVEMP, DESPRVEMP , PRVSS,  REGEMP,  "
			+ "SUPERF,  TECINS,  TECOSL, TERAPE,  TIPAPE, TIPAPEES, TIPAPEEUS, TIPDOC,  TLFCTR,  TLFEMP,  TLFREPRESENTANTE,  TRBHOM,  TRBMUJ,  TRBTOT,  USUALT,  USUMOD,  VISINS,  "
			+ "VISOSL, FOLDERID, CODDATOSNOTIF, MIGRADO, MAILCONTACTOSOLIC, TELEFCONTACTOSOLIC, RAZONSOCIALANT, DIRECCANT,FECFINPLAZO,USUARIOAPE, USUARIOAPORT, USUARIOTRAM, NVL((select codigo_088 from AB0488T00 where codtabla_088='DIAS_FUERAPLAZO'),30) AS DIASFINPLAZO";
	private static final String QUERY_FROM_COMUNICACION_APERTURA = " FROM VCOMUNICACION_APERTURA COMUNIC_APE ";

	private static final String QUERY_SELECT_COMUNICACION_APERTURA_DETALLE = " SELECT  (TERAPE||'/'||ANOAPE||'/'||NUMAPE) AS ID,ANOAPE,APDOANX,ASGINS,ASGOSL,CANALEVAL,CANALPLAN,  CLASCTR,  CNAECTR,  CNAECTR93,  CNAEEMP,  "
			+ "CNAEEMP93,  CODCTR,  CODENTIAT,  CODOBRA,  CPOCTR,  CPOEMP,  DESCMAQ,  DESCOBR,  DESTRAB,  DIGSS,  DIRCTR,  DIREMP,  DMUNEMP,  "
			+ "DOCCORRECTA, EMAILCTR,  ENTIAT,  ESTADOCIER,  ESTADO,  EVALPRES,  FAXCTR,  FECALT,  FECIER,  FECINI,  FECINSP,  FECMOD,  FECPRE,  FECREQ,  FECSUB,  "
			+ "FINFINSP,  FINFOSL, FORPRE,  FVISINS,  FVISOSL,  IDAPE,  INDANX,  INDOBRA,  LOCCTR,  LOTEMNT,  MODPRE,  MUNCTR, DESMUNCTR,  MUNEMP, DESMUNEMP,  NOMCTR,  NOMEMP,  NUEVA,  "
			+ "NUMAPE,  NUMCNT,  NUMDOCREPRESENTANTE,NOMREPRESENTANTE,TIPDOCREPRESENTANTE,  NUMDOC,  NUMSS,  PLANPRES,  PLANSEG,  POTEN,  PROYTEC, PRVCTR, DESPRVCTR,  PAISEMP, PRVEMP, DESPRVEMP,  PRVSS,  REGEMP,  "
			+ "SUPERF,  TECINS,  TECOSL, TERAPE,  TIPAPE, TIPAPEES, TIPAPEEUS, TIPDOC,  TLFCTR,  TLFEMP,  TLFREPRESENTANTE,  TRBHOM,  TRBMUJ,  TRBTOT,  USUALT,  USUMOD,  VISINS,  "
			+ "VISOSL, FOLDERID, CODDATOSNOTIF, MIGRADO, MAILCONTACTOSOLIC, TELEFCONTACTOSOLIC, RAZONSOCIALANT, DIRECCANT,FECFINPLAZO, USUARIOAPE, USUARIOAPORT, USUARIOTRAM, null AS DIASFINPLAZO";

	private static final String QUERY_JOIN_PARTICIPANTES = " INNER JOIN VPARTICIPANTES_OBRA t1 ON t1.TER_PART = COMUNIC_APE.TERAPE AND t1.ANO_PART = COMUNIC_APE.ANOAPE AND t1.NUM_PART = COMUNIC_APE.NUMAPE ";
	private static final String QUERY_JOIN_DURACIONPREVOBRA = " LEFT OUTER JOIN  AB0482S00 OBRA ON (OBRA.TEREXP_082 = COMUNIC_APE.TERAPE AND OBRA.ANOEXP_082 = COMUNIC_APE.ANOAPE AND OBRA.NUMEXP_082 = COMUNIC_APE.NUMAPE AND OBRA.CODOBRA_082 = COMUNIC_APE.CODOBRA) ";

	private static final String QUERY_SELECT_DATOS_ETIQUETAS = " SELECT t1.TERAPE_056 TERAPE, t1.ANOAPE_056 ANOAPE,  t1.NUMAPE_056 NUMAPE,  t1.NOMEMP_056 NOMEMP,  t3.CALLE_067 CALLE, t3.CODPOSTAL_067 CP,"
			+ " t3.COD_MUNICIPIO_067 CODMUNI, d1.DS_O MUNIDESC, t3.PORTAL_067 PORTAL, t3.PISO_067 PISO, t3.PUERTA_067 PUERTA, t3.COD_LOCALIDAD_067 CODLOCALI, d2.DESCRIPCION LOCALIDESC, t3.COD_PROVINCIA_067 CODPROV, d3.DS_O PROVDESC ";

	private static final String QUERY_FROM_DATOS_ETIQUETAS = " FROM AB0456T00 t1 LEFT JOIN AB0466T00 t2 ON t1.COD_DATOS_NOTIF_056 = t2.COD_DATOS_NOTIF_066 LEFT JOIN AB0467T00 t3 "
			+ "ON t2.COD_LOCALIZACION_066 = t3.COD_LOCALIZACION_067 LEFT JOIN MUNICIPIO_NORA d1 ON d1.PROVINCIA_ID = t3.COD_PROVINCIA_067 AND d1.ID = t3.COD_MUNICIPIO_067 "
			+ "LEFT JOIN LOCALIDAD_NORA d2 ON d2.COD_LOCALIDAD = t3.COD_LOCALIDAD_067 LEFT JOIN PROVINCIA_NORA d3 ON d3.ID = t3.COD_PROVINCIA_067 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ComunicacionApertura> rwMap = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura(
					resultSet.getString("ANOAPE"), resultSet.getLong("NUMAPE"),
					resultSet.getDate("FECPRE"), resultSet.getDate("FECIER"),
					resultSet.getString("NUEVA"), resultSet.getString("TIPDOC"),
					resultSet.getString("NUMDOC"),
					resultSet.getString("NOMEMP"),
					resultSet.getString("PAISEMP"),
					new Provincia(resultSet.getString("PRVEMP"),
							resultSet.getString("DESPRVEMP"), ""),
					new Municipio(resultSet.getString("PRVEMP"),
							resultSet.getString("MUNEMP"),
							resultSet.getString("DESMUNEMP")),
					resultSet.getString("DMUNEMP"),
					resultSet.getString("DIREMP"),
					resultSet.getString("CPOEMP"),
					resultSet.getString("TLFEMP"),
					resultSet.getString("CNAEEMP"),
					resultSet.getString("ENTIAT"),
					new TipoApertura(resultSet.getString("TIPAPE"),
							resultSet.getString("TIPAPEES"),
							resultSet.getString("TIPAPEEUS")),
					resultSet.getString("NOMCTR"),
					new Provincia(resultSet.getString("PRVCTR"),
							resultSet.getString("DESPRVCTR"), ""),
					new Municipio(resultSet.getString("PRVCTR"),
							resultSet.getString("MUNCTR"),
							resultSet.getString("DESMUNCTR")),
					resultSet.getString("LOCCTR"),
					resultSet.getString("DIRCTR"),
					resultSet.getString("CPOCTR"),
					resultSet.getString("TLFCTR"),
					resultSet.getString("FAXCTR"),
					resultSet.getString("EMAILCTR"),
					resultSet.getString("CNAECTR"),
					resultSet.getString("PRVSS"), resultSet.getString("NUMSS"),
					resultSet.getString("DIGSS"), resultSet.getDate("FECINI"),
					resultSet.getLong("TRBHOM"), resultSet.getLong("TRBMUJ"),
					resultSet.getLong("TRBTOT"), resultSet.getString("CLASCTR"),
					resultSet.getString("DESCOBR"), resultSet.getInt("SUPERF"),
					resultSet.getString("PLANSEG"),
					resultSet.getString("CANALPLAN"),
					resultSet.getString("PLANPRES"),
					resultSet.getString("PROYTEC"),
					resultSet.getString("DESCMAQ"),
					resultSet.getBigDecimal("POTEN"),
					resultSet.getString("INDANX"),
					resultSet.getString("APDOANX"),
					resultSet.getString("DESTRAB"),
					resultSet.getString("INDOBRA"),
					resultSet.getLong("CODOBRA"), resultSet.getInt("CODCTR"),
					resultSet.getString("LOTEMNT"),
					resultSet.getString("VISOSL"),
					resultSet.getString("ASGOSL"),
					resultSet.getString("TECOSL"), resultSet.getDate("FVISOSL"),
					resultSet.getString("VISINS"),
					resultSet.getString("ASGINS"),
					resultSet.getString("TECINS"), resultSet.getDate("FVISINS"),
					resultSet.getDate("FECINSP"), resultSet.getDate("FECREQ"),
					resultSet.getDate("FECSUB"), resultSet.getDate("FINFOSL"),
					resultSet.getDate("FINFINSP"), resultSet.getDate("FECALT"),
					resultSet.getString("USUALT"), resultSet.getDate("FECMOD"),
					resultSet.getString("USUMOD"),
					resultSet.getString("DOCCORRECTA"),
					resultSet.getString("CODENTIAT"),
					resultSet.getString("ESTADOCIER"),
					resultSet.getString("ESTADO"),
					resultSet.getString("CNAECTR93"),
					resultSet.getString("CNAEEMP93"),
					resultSet.getInt("MODPRE"), resultSet.getLong("NUMCNT"),
					resultSet.getLong("IDAPE"), resultSet.getString("EVALPRES"),
					resultSet.getString("CANALEVAL"),
					resultSet.getString("REGEMP"),
					resultSet.getString("NUMDOCREPRESENTANTE"),
					resultSet.getString("NOMREPRESENTANTE"),
					resultSet.getString("TIPDOCREPRESENTANTE"),
					resultSet.getString("TLFREPRESENTANTE"),
					resultSet.getString("TERAPE"),
					resultSet.getString("FORPRE"),
					resultSet.getString("FOLDERID"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF")),
					resultSet.getString("MAILCONTACTOSOLIC"),
					resultSet.getString("TELEFCONTACTOSOLIC"),
					resultSet.getString("RAZONSOCIALANT"),
					resultSet.getString("DIRECCANT"),
					resultSet.getDate("FECFINPLAZO"),
					resultSet.getString("USUARIOAPE"),
					resultSet.getString("USUARIOAPORT"),
					resultSet.getString("USUARIOTRAM"));

			if (UtilDAO.hasColumn(resultSet, "MIGRADO")) {
				comunicacionApertura
						.setMigrado056(resultSet.getString("MIGRADO"));
			}
			if (UtilDAO.hasColumn(resultSet, "NEXTROW")) {
				comunicacionApertura.setNext(resultSet.getString("NEXTROW"));
			}
			if (UtilDAO.hasColumn(resultSet, "PREVIOUSROW")) {
				comunicacionApertura
						.setPrev(resultSet.getString("PREVIOUSROW"));
			}

			comunicacionApertura
					.setDiasFueraPlazo(resultSet.getInt("DIASFINPLAZO"));

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapListadoAperturas = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura(
					resultSet.getString("ANOAPE"), resultSet.getLong("NUMAPE"),
					resultSet.getDate("FECPRE"), resultSet.getDate("FECIER"),
					resultSet.getString("NUEVA"), resultSet.getString("TIPDOC"),
					resultSet.getString("NUMDOC"),
					resultSet.getString("NOMEMP"),
					resultSet.getString("PAISEMP"),
					new Provincia(resultSet.getString("PRVEMP"),
							resultSet.getString("DESPRVEMP"), ""),
					new Municipio(resultSet.getString("PRVEMP"),
							resultSet.getString("MUNEMP"),
							resultSet.getString("DESMUNEMP")),
					resultSet.getString("DMUNEMP"),
					resultSet.getString("DIREMP"),
					resultSet.getString("CPOEMP"),
					resultSet.getString("TLFEMP"),
					resultSet.getString("CNAEEMP"),
					resultSet.getString("ENTIAT"),
					new TipoApertura(resultSet.getString("TIPAPE"),
							resultSet.getString("TIPAPEES"),
							resultSet.getString("TIPAPEEUS")),
					resultSet.getString("NOMCTR"),
					new Provincia(resultSet.getString("PRVCTR"),
							resultSet.getString("DESPRVCTR"), ""),
					new Municipio(resultSet.getString("PRVCTR"),
							resultSet.getString("MUNCTR"),
							resultSet.getString("DESMUNCTR")),
					resultSet.getString("LOCCTR"),
					resultSet.getString("DIRCTR"),
					resultSet.getString("CPOCTR"),
					resultSet.getString("TLFCTR"),
					resultSet.getString("FAXCTR"),
					resultSet.getString("EMAILCTR"),
					resultSet.getString("CNAECTR"),
					resultSet.getString("PRVSS"), resultSet.getString("NUMSS"),
					resultSet.getString("DIGSS"), resultSet.getDate("FECINI"),
					resultSet.getLong("TRBHOM"), resultSet.getLong("TRBMUJ"),
					resultSet.getLong("TRBTOT"), resultSet.getString("CLASCTR"),
					resultSet.getString("DESCOBR"), resultSet.getInt("SUPERF"),
					resultSet.getString("PLANSEG"),
					resultSet.getString("CANALPLAN"),
					resultSet.getString("PLANPRES"),
					resultSet.getString("PROYTEC"),
					resultSet.getString("DESCMAQ"),
					resultSet.getBigDecimal("POTEN"),
					resultSet.getString("INDANX"),
					resultSet.getString("APDOANX"),
					resultSet.getString("DESTRAB"),
					resultSet.getString("INDOBRA"),
					resultSet.getLong("CODOBRA"), resultSet.getInt("CODCTR"),
					resultSet.getString("LOTEMNT"),
					resultSet.getString("VISOSL"),
					resultSet.getString("ASGOSL"),
					resultSet.getString("TECOSL"), resultSet.getDate("FVISOSL"),
					resultSet.getString("VISINS"),
					resultSet.getString("ASGINS"),
					resultSet.getString("TECINS"), resultSet.getDate("FVISINS"),
					resultSet.getDate("FECINSP"), resultSet.getDate("FECREQ"),
					resultSet.getDate("FECSUB"), resultSet.getDate("FINFOSL"),
					resultSet.getDate("FINFINSP"), resultSet.getDate("FECALT"),
					resultSet.getString("USUALT"), resultSet.getDate("FECMOD"),
					resultSet.getString("USUMOD"),
					resultSet.getString("DOCCORRECTA"),
					resultSet.getString("CODENTIAT"),
					resultSet.getString("ESTADOCIER"),
					resultSet.getString("ESTADO"),
					resultSet.getString("CNAECTR93"),
					resultSet.getString("CNAEEMP93"),
					resultSet.getInt("MODPRE"), resultSet.getLong("NUMCNT"),
					resultSet.getLong("IDAPE"), resultSet.getString("EVALPRES"),
					resultSet.getString("CANALEVAL"),
					resultSet.getString("REGEMP"),
					resultSet.getString("NUMDOCREPRESENTANTE"),
					resultSet.getString("NOMREPRESENTANTE"),
					resultSet.getString("TIPDOCREPRESENTANTE"),
					resultSet.getString("TLFREPRESENTANTE"),
					resultSet.getString("TERAPE"),
					resultSet.getString("FORPRE"),
					resultSet.getString("FOLDERID"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF")),
					resultSet.getString("MAILCONTACTOSOLIC"),
					resultSet.getString("TELEFCONTACTOSOLIC"),
					resultSet.getString("RAZONSOCIALANT"),
					resultSet.getString("DIRECCANT"),
					resultSet.getDate("FECFINPLAZO"),
					resultSet.getString("USUARIOAPE"),
					resultSet.getString("USUARIOAPORT"),
					resultSet.getString("USUARIOTRAM"));

			if (UtilDAO.hasColumn(resultSet, "MIGRADO")) {
				comunicacionApertura
						.setMigrado056(resultSet.getString("MIGRADO"));
			}
			if (UtilDAO.hasColumn(resultSet, "NEXTROW")) {
				comunicacionApertura.setNext(resultSet.getString("NEXTROW"));
			}
			if (UtilDAO.hasColumn(resultSet, "PREVIOUSROW")) {
				comunicacionApertura
						.setPrev(resultSet.getString("PREVIOUSROW"));
			}
			if (UtilDAO.hasColumn(resultSet, ("DESCVISOSL"))) {
				comunicacionApertura
						.setDescVisosl(resultSet.getString("DESCVISOSL"));
			}

			comunicacionApertura
					.setDiasFueraPlazo(resultSet.getInt("DIASFINPLAZO"));

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapListadoMeses = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			int mes = Integer.valueOf(resultSet.getString("MES") != null
					? resultSet.getString("MES") : "");
			comunicacionApertura.setMes(Utilities.getInstance().strMonth(mes));

			String terape = resultSet.getString("TERAPE") != null
					? resultSet.getString("TERAPE") : "";
			comunicacionApertura.setTerapeDesc(
					Utilities.getInstance().strTerritorio(terape));
			comunicacionApertura.setTerape056(terape);

			comunicacionApertura.setNumAperturas(
					(Integer.valueOf(resultSet.getInt("NUMAPERTURAS")))
							.toString());

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapListadoTramosPorCentro = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			String terape = resultSet.getString("TERAPE") != null
					? resultSet.getString("TERAPE") : "";
			comunicacionApertura.setTerapeDesc(
					Utilities.getInstance().strTerritorio(terape));

			String tipoCtr = resultSet.getString("CLASCTR") != null
					? resultSet.getString("CLASCTR") : "";
			comunicacionApertura.setClasctr056(tipoCtr);
			String desctipoCtr = resultSet.getString("DESCCLASCTR") != null
					? resultSet.getString("DESCCLASCTR") : "";
			comunicacionApertura.setDescTipoCtr(desctipoCtr);

			comunicacionApertura.setNumAperturas(
					(Integer.valueOf(resultSet.getInt("RESULT"))).toString());

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapListadoTramosTrabajadores = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			String terape = resultSet.getString("TERAPE") != null
					? resultSet.getString("TERAPE") : "";
			comunicacionApertura.setTerapeDesc(
					Utilities.getInstance().strTerritorio(terape));

			String numMes = resultSet.getString("NUMMES") != null
					? resultSet.getString("NUMMES") : "";
			comunicacionApertura.setNumMes(numMes);
			comunicacionApertura.setMes(
					Utilities.getInstance().strMonth(Integer.parseInt(numMes)));

			String tipoPart = resultSet.getString("TIPOPART") != null
					? resultSet.getString("TIPOPART") : "";
			comunicacionApertura.setTipoPart(tipoPart);

			String result = resultSet.getString("RESULT") != null
					? resultSet.getString("RESULT") : "";
			comunicacionApertura.setNumAperturas(result);

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapListadoSectores = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			comunicacionApertura.setSector(resultSet.getString("SECTOR"));
			comunicacionApertura
					.setSectorDesc(resultSet.getString("SECTORDESC"));

			String terape = resultSet.getString("TERAPE") != null
					? resultSet.getString("TERAPE") : "";
			comunicacionApertura.setTerapeDesc(
					Utilities.getInstance().strTerritorio(terape));
			comunicacionApertura.setTerape056(terape);

			comunicacionApertura.setNumAperturas(
					(Integer.valueOf(resultSet.getInt("NUMAPERTURAS")))
							.toString());
			comunicacionApertura.setCnaectr056(resultSet.getString("CNAECTR"));
			comunicacionApertura.setCnaeemp056(resultSet.getString("CNAEEMP"));

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapListadoOsalan = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			comunicacionApertura.setTerape056(resultSet.getString("TERAPE"));
			comunicacionApertura.setAnoape056(resultSet.getString("ANOAPE"));
			comunicacionApertura.setNumape056(resultSet.getLong("NUMAPE"));
			comunicacionApertura.setFecpre056(resultSet.getDate("FECPRE"));
			comunicacionApertura.setNumdoc056(resultSet.getString("NUMDOC"));
			comunicacionApertura.setNomemp056(resultSet.getString("NOMEMP"));
			comunicacionApertura.setProvinciaCtr(
					new Provincia(resultSet.getString("PRVCTR"),
							resultSet.getString("DESPRVCTR"), ""));
			comunicacionApertura.setMunicipioCtr(
					new Municipio(resultSet.getString("PRVCTR"),
							resultSet.getString("MUNCTR"),
							resultSet.getString("DESMUNCTR")));
			comunicacionApertura.setDirctr056(resultSet.getString("DIRCTR"));
			comunicacionApertura.setVisosl056(resultSet.getString("VISOSL"));

			Locale locale = LocaleContextHolder.getLocale();
			if (locale.getLanguage().equals(Constantes.LOCALE_EU)) {
				comunicacionApertura
						.setVisita(resultSet.getString("DESCVISITA_EU"));
			} else {
				comunicacionApertura
						.setVisita(resultSet.getString("DESCVISITA"));
			}

			comunicacionApertura.setFinfinsp056(resultSet.getDate("FINFINSP"));

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapListadoSubsanacion = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			comunicacionApertura.setTerape056(resultSet.getString("TERAPE"));
			comunicacionApertura.setAnoape056(resultSet.getString("ANOAPE"));
			comunicacionApertura.setNumape056(resultSet.getLong("NUMAPE"));
			comunicacionApertura.setFecpre056(resultSet.getDate("FECPRE"));
			comunicacionApertura.setNumdoc056(resultSet.getString("NUMDOC"));
			comunicacionApertura.setNomemp056(resultSet.getString("NOMEMP"));
			comunicacionApertura.setNomctr056(resultSet.getString("NOMCTR"));
			comunicacionApertura.setProvinciaCtr(
					new Provincia(resultSet.getString("PRVCTR"),
							resultSet.getString("DESPRVCTR"), ""));
			comunicacionApertura.setMunicipioCtr(
					new Municipio(resultSet.getString("PRVCTR"),
							resultSet.getString("MUNCTR"),
							resultSet.getString("DESMUNCTR")));
			comunicacionApertura.setDirctr056(resultSet.getString("DIRCTR"));
			comunicacionApertura.setFecreq056(resultSet.getDate("FECREQ"));

			return comunicacionApertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapDatosEtiquetas = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			String terape = resultSet.getString("TERAPE") != null
					? resultSet.getString("TERAPE") : "";
			comunicacionApertura.setTerape056(terape);
			comunicacionApertura.setTerapeDesc(
					Utilities.getInstance().strTerritorio(terape));

			String anoape = resultSet.getString("ANOAPE") != null
					? resultSet.getString("ANOAPE") : "";
			comunicacionApertura.setAnoape056(anoape);

			Long numape = resultSet.getLong("NUMAPE") > 0
					? resultSet.getLong("NUMAPE") : 0;
			comunicacionApertura.setNumape056(numape);

			String nomemp = resultSet.getString("NOMEMP") != null
					? resultSet.getString("NOMEMP") : "";
			comunicacionApertura.setNomemp056(nomemp);

			DatosLocalizacion datosloc = new DatosLocalizacion();
			String cp = resultSet.getString("CP") != null
					? resultSet.getString("CP") : "";
			datosloc.setCodpostal067(cp);

			String calle = resultSet.getString("CALLE") != null
					? resultSet.getString("CALLE") : "";
			datosloc.setCalle067(calle);

			String portal = resultSet.getString("PORTAL") != null
					? resultSet.getString("PORTAL") : "";
			datosloc.setPortal067(portal);
			String piso = resultSet.getString("PISO") != null
					? resultSet.getString("PISO") : "";
			datosloc.setPiso067(piso);
			String puerta = resultSet.getString("PUERTA") != null
					? resultSet.getString("PUERTA") : "";
			datosloc.setPuerta067(puerta);

			String codprov = resultSet.getString("CODPROV") != null
					? resultSet.getString("CODPROV") : "";
			String provdesc = resultSet.getString("PROVDESC") != null
					? resultSet.getString("PROVDESC") : "";
			Provincia prov = new Provincia();
			prov.setCodProvincia(codprov);
			prov.setDescripcion(provdesc);
			datosloc.setProvincia(prov);

			String codmuni = resultSet.getString("CODMUNI") != null
					? resultSet.getString("CODMUNI") : "";
			String munidesc = resultSet.getString("MUNIDESC") != null
					? resultSet.getString("MUNIDESC") : "";
			datosloc.setMunicipio(new Municipio(codprov, codmuni, munidesc));
			String codlocalidad = resultSet.getString("CODLOCALI") != null
					? resultSet.getString("CODLOCALI") : "";
			String localidesc = resultSet.getString("LOCALIDESC") != null
					? resultSet.getString("LOCALIDESC") : "";
			datosloc.setLocalidad(
					new Localidad(codprov, codmuni, codlocalidad, localidesc));

			DatosNotificacion datosnotif = new DatosNotificacion();
			datosnotif.setDatosLocalizacion(datosloc);
			comunicacionApertura.setDatosNotificacion(datosnotif);

			return comunicacionApertura;
		}
	};

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> vistaFindAllLike(
			ComunicacionApertura ab04b56s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaCustomDaoImpl.QUERY_SELECT_COMUNICACION_APERTURA);
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// si se filtra por Participante
		if (ab04b56s00 != null && (ab04b56s00.getNumdocPart() != null
				|| ab04b56s00.getNomPart() != null)) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_PARTICIPANTES);
		}
		// si se filtra por Duracion prevista
		if (ab04b56s00 != null && ab04b56s00.getObra() != null
				&& ab04b56s00.getObra().getDurpreDesde() != null
				&& ab04b56s00.getObra().getDurpreHasta() != null
				&& ab04b56s00.getObra().getUnitmp082() != null) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_DURACIONPREVOBRA);
		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(ab04b56s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ComunicacionApertura>) this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 startsWith Boolean Long
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long vistaFindAllLikeCount(ComunicacionApertura ab04b56s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)").append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// si se filtra por Participante
		if (ab04b56s00 != null && ab04b56s00.getNumdocPart() != null
				|| ab04b56s00.getNomPart() != null) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_PARTICIPANTES);
		}
		// si se filtra por Duracion prevista
		if (ab04b56s00 != null && ab04b56s00.getObra() != null
				&& ab04b56s00.getObra().getDurpreDesde() != null
				&& ab04b56s00.getObra().getDurpreHasta() != null
				&& ab04b56s00.getObra().getUnitmp082() != null) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_DURACIONPREVOBRA);
		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(ab04b56s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<ComunicacionApertura> listadoFindAllLike(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaCustomDaoImpl.QUERY_SELECT_COMUNICACION_APERTURA);
		query.append(", t1.DESCRIPCION_088 DESCVISOSL ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		query.append(
				" LEFT JOIN AB0488S00 t1 ON t1.CODTABLA_088 = 'EST_VISOSL' AND t1.CODIGO_088 = COMUNIC_APE.VISOSL ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ComunicacionApertura>) this.getJdbcTemplate().query(
				query.toString(), this.rwMapListadoAperturas, params.toArray());
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * comunicacionApertura ComunicacionApertura b Boolean Long
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param b
	 *            the b
	 * @return the long
	 */
	public Long listadoFindAllLikeCount(
			ComunicacionApertura comunicacionApertura, boolean b) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)").append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		query.append(
				" LEFT JOIN AB0488S00 t1 ON t1.CODTABLA_088 = 'EST_VISOSL' AND t1.CODIGO_088 = COMUNIC_APE.VISOSL ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getVistaWhereLikeMap(comunicacionApertura, b);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Vista find detalle.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * filtro ComunicacionApertura HExpediente
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura vistaFindDetalle(
			ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto, ComunicacionApertura filtro) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaCustomDaoImpl.STRING_BUILDER_INIT);
		List<ComunicacionApertura> comunicacionesApeList = null;

		boolean anteriorSiguiente = false;
		if (jqGridRequestDto != null && filtro != null) {
			anteriorSiguiente = true;
			// Se ha hecho una peticion, para recuperar anterior y siguiente

			// CHECKSTYLE:OFF El '*' se ejecuta sobre una subselect
			query.append("SELECT * FROM ( ");
			// CHECKSTYLE:ON

			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_SELECT_COMUNICACION_APERTURA_DETALLE);

			query.append(
					", LAG ((TERAPE||'/'||ANOAPE||'/'||NUMAPE)) OVER (ORDER BY ");
			query.append(jqGridRequestDto.getSidx()).append(" ")
					.append(jqGridRequestDto.getSord());
			query.append(") PREVIOUSROW, ");
			query.append(
					" LEAD ((TERAPE||'/'||ANOAPE||'/'||NUMAPE)) OVER (ORDER BY ");
			query.append(jqGridRequestDto.getSidx()).append(" ")
					.append(jqGridRequestDto.getSord());
			query.append(") NEXTROW ");
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

			// si se filtra por Participante
			if (filtro != null && (filtro.getNumdocPart() != null
					|| filtro.getNomPart() != null)) {
				query.append(
						ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_PARTICIPANTES);
			}
			// si se filtra por Duracion prevista
			if (filtro != null && filtro.getObra() != null
					&& filtro.getObra().getDurpreDesde() != null
					&& filtro.getObra().getDurpreHasta() != null
					&& filtro.getObra().getUnitmp082() != null) {
				query.append(
						ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_DURACIONPREVOBRA);
			}

			// Where clause & Params
			Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro, false);
			StringBuilder where = new StringBuilder(" WHERE 1=1 ");
			where.append(mapaWhere.get("query"));
			query.append(where);

			List<Object> params = (List<Object>) mapaWhere.get("params");
			query.append(") WHERE TERAPE=? AND ANOAPE=? AND NUMAPE=?");
			params.add(comunicApertura.getTerape056());
			params.add(comunicApertura.getAnoape056());
			params.add(comunicApertura.getNumape056());

			comunicacionesApeList = this.getJdbcTemplate()
					.query(query.toString(), this.rwMap, params.toArray());

		}

		if (!anteriorSiguiente
				|| (anteriorSiguiente && comunicacionesApeList.isEmpty())) {
			/**
			 * Se ha hecho una peticion normal, sin recuperar anterior y
			 * siguiente o se ha modificado alguna propiedad del expediente en
			 * el filtro y ya no lo encuentra al recargar el expediente
			 */
			query = new StringBuilder(
					ComunicacionAperturaCustomDaoImpl.STRING_BUILDER_INIT);
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_SELECT_COMUNICACION_APERTURA_DETALLE);
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
			// si se filtra por Participante
			if (filtro != null && (filtro.getNumdocPart() != null
					|| filtro.getNomPart() != null)) {
				query.append(
						ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_PARTICIPANTES);
			}
			// si se filtra por Duracion prevista
			if (filtro != null && filtro.getObra() != null
					&& filtro.getObra().getDurpreDesde() != null
					&& filtro.getObra().getDurpreHasta() != null
					&& filtro.getObra().getUnitmp082() != null) {
				query.append(
						ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_DURACIONPREVOBRA);
			}
			query.append(" WHERE TERAPE=? AND ANOAPE=? AND NUMAPE=? ");

			comunicacionesApeList = this.getJdbcTemplate().query(
					query.toString(), this.rwMap,
					comunicApertura.getTerape056(),
					comunicApertura.getAnoape056(),
					comunicApertura.getNumape056());
		}
		// return (ComunicacionApertura) DataAccessUtils
		// .uniqueResult(comunicacionesApeList);
		return comunicacionesApeList.get(0);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura vFind(ComunicacionApertura ab04b56s00) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.STRING_BUILDER_INIT);
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_SELECT_COMUNICACION_APERTURA_DETALLE);
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		// si se filtra por Participante
		if (ab04b56s00 != null && (ab04b56s00.getNumdocPart() != null
				|| ab04b56s00.getNomPart() != null)) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_PARTICIPANTES);
		}
		// si se filtra por Duracion prevista
		if (ab04b56s00 != null && ab04b56s00.getObra() != null
				&& ab04b56s00.getObra().getDurpreDesde() != null
				&& ab04b56s00.getObra().getDurpreHasta() != null
				&& ab04b56s00.getObra().getUnitmp082() != null) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_DURACIONPREVOBRA);
		}
		query.append(" WHERE TERAPE=? AND ANOAPE=? AND NUMAPE=? ");

		List<ComunicacionApertura> ab04b56s00List = this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, ab04b56s00.getTerape056(),
						ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura vFindDetalle(ComunicacionApertura ab04b56s00) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.STRING_BUILDER_INIT);
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_SELECT_COMUNICACION_APERTURA);
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		// si se filtra por Participante
		if (ab04b56s00 != null && (ab04b56s00.getNumdocPart() != null
				|| ab04b56s00.getNomPart() != null)) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_PARTICIPANTES);
		}
		// si se filtra por Duracion prevista
		if (ab04b56s00 != null && ab04b56s00.getObra() != null
				&& ab04b56s00.getObra().getDurpreDesde() != null
				&& ab04b56s00.getObra().getDurpreHasta() != null
				&& ab04b56s00.getObra().getUnitmp082() != null) {
			query.append(
					ComunicacionAperturaCustomDaoImpl.QUERY_JOIN_DURACIONPREVOBRA);
		}
		query.append(" WHERE TERAPE=? AND ANOAPE=? AND NUMAPE=? ");

		List<ComunicacionApertura> ab04b56s00List = this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, ab04b56s00.getTerape056(),
						ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b56s00 entity.
	 * 
	 * ab04b56s00 Ab04b56s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the vista where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getVistaWhereLikeMap(
			ComunicacionApertura ab04b56s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ComunicacionAperturaCustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		String mascara = Utilities.getInstance().getDateMask();

		// territorio
		if (ab04b56s00 != null && ab04b56s00.getTerape056() != null) {
			where.append(" AND UPPER(TERAPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTerape056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTerape056().toUpperCase() + "%");
			}
			where.append(" AND TERAPE IS NOT NULL");
		}

		// año
		if (ab04b56s00 != null && ab04b56s00.getAnoape056() != null) {
			where.append(" AND UPPER(ANOAPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getAnoape056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getAnoape056().toUpperCase() + "%");
			}
			where.append(" AND ANOAPE IS NOT NULL");
		}

		// num expediente
		if (ab04b56s00 != null && ab04b56s00.getNumape056() != null) {
			where.append(" AND NUMAPE = ?");
			params.add(ab04b56s00.getNumape056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumExpDesde() != null) {
			where.append(" AND NUMAPE >= ?");
			params.add(ab04b56s00.getNumExpDesde());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumExpHasta() != null) {
			where.append(" AND NUMAPE <= ?");
			params.add(ab04b56s00.getNumExpHasta());
		}

		// periodo presentacion
		if (ab04b56s00 != null && ab04b56s00.getFecpre056() != null) {
			where.append(" AND FECPRE = ?");
			params.add(ab04b56s00.getFecpre056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecpreDesde() != null) {
			where.append(" AND TRUNC(FECPRE) >= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecpreDesdeStr());
			params.add(mascara);
		}
		if (ab04b56s00 != null && ab04b56s00.getFecpreHasta() != null) {
			where.append(" AND TRUNC(FECPRE) <= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecpreHastaStr());
			params.add(mascara);
		}

		// tipo apertura
		if (ab04b56s00 != null && ab04b56s00.getTipoApertura() != null
				&& ab04b56s00.getTipoApertura().getTipape071() != null) {
			where.append(" AND UPPER(TIPAPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTipoApertura().getTipape071()
						.toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTipoApertura().getTipape071()
						+ "%");
			}
			where.append(" AND TIPAPE IS NOT NULL");
		}

		// indicador obra
		if (ab04b56s00 != null && ab04b56s00.getIndobra056() != null) {
			where.append(" AND UPPER(INDOBRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getIndobra056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getIndobra056().toUpperCase() + "%");
			}
			where.append(" AND INDOBRA IS NOT NULL");
		}

		// Duracion prevista
		if (ab04b56s00 != null && ab04b56s00.getObra() != null
				&& ab04b56s00.getObra().getDurpreDesde() != null
				&& ab04b56s00.getObra().getDurpreHasta() != null
				&& ab04b56s00.getObra().getUnitmp082() != null) {
			where.append(" AND OBRA.DURPRE_082 >= ? ");
			params.add(Integer.valueOf(ab04b56s00.getObra().getDurpreDesde()));
			where.append(" AND OBRA.DURPRE_082 IS NOT NULL");

			where.append(" AND OBRA.DURPRE_082 <= ? ");
			params.add(Integer.valueOf(ab04b56s00.getObra().getDurpreHasta()));
			where.append(" AND OBRA.DURPRE_082 IS NOT NULL");

			where.append(" AND UPPER(OBRA.UNITMP_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getObra().getUnitmp082().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + ab04b56s00.getObra().getUnitmp082().toUpperCase()
								+ "%");
			}
			where.append(" AND OBRA.UNITMP_082 IS NOT NULL");
		}

		// Participante
		if (ab04b56s00 != null && ab04b56s00.getNumdocPart() != null) {
			where.append(" AND UPPER(t1.NUMDOC_PART) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNumdocPart().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getNumdocPart().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_PART IS NOT NULL");
		}

		// nombre paricipante
		if (ab04b56s00 != null && ab04b56s00.getNomPart() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PART) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNomPart().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getNomPart().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PART IS NOT NULL");
		}

		if (ab04b56s00 != null
				&& (ab04b56s00.getNumdocPart() != null
						|| ab04b56s00.getNomPart() != null)
				&& ab04b56s00.getTipoPart() != null) {
			where.append(" AND UPPER(t1.ROL_PART) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTipoPart().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTipoPart().toUpperCase() + "%");
			}
			where.append(" AND t1.ROL_PART IS NOT NULL");
		}

		// tipo identificacion
		if (ab04b56s00 != null && ab04b56s00.getTipdoc056() != null) {
			where.append(" AND UPPER(TIPDOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTipdoc056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTipdoc056().toUpperCase() + "%");
			}
			where.append(" AND TIPDOC IS NOT NULL");
		}

		// numero identificacion
		if (ab04b56s00 != null && ab04b56s00.getNumdoc056() != null) {
			where.append(" AND UPPER(NUMDOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNumdoc056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getNumdoc056().toUpperCase() + "%");
			}
			where.append(" AND NUMDOC IS NOT NULL");
		}

		// nombre empresa
		if (ab04b56s00 != null && ab04b56s00.getNomemp056() != null) {
			where.append(
					" AND UPPER(translate(NOMEMP, 'áéíóúÁÉÍÓÚ', 'aeiouAEIOU')) like '%'||UPPER(translate(?, 'áéíóúÁÉÍÓÚ', 'aeiouAEIOU'))||'%' ESCAPE  '\\'");
			params.add(ab04b56s00.getNomemp056().toUpperCase());

			where.append(" AND NOMEMP IS NOT NULL");
		}

		// clase centro trabajo
		if (ab04b56s00 != null && ab04b56s00.getClasctr056() != null) {
			where.append(" AND UPPER(CLASCTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getClasctr056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getClasctr056().toUpperCase() + "%");
			}
			where.append(" AND CLASCTR IS NOT NULL");
		}

		// municipio centro trabajo
		if (ab04b56s00 != null && ab04b56s00.getMunicipioCtr() != null
				&& ab04b56s00.getMunicipioCtr().getCodMunicipio() != null) {
			where.append(" AND UPPER(MUNCTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getMunicipioCtr().getCodMunicipio()
						.toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getMunicipioCtr().getCodMunicipio()
						.toUpperCase() + "%");
			}
			where.append(" AND MUNCTR IS NOT NULL");
		}

		// cnae centro trabajo
		if (ab04b56s00 != null && ab04b56s00.getCnaectr056() != null) {
			where.append(" AND UPPER(CNAECTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCnaectr056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCnaectr056().toUpperCase() + "%");
			}
			where.append(" AND CNAECTR IS NOT NULL");
		}

		// cnae empresa
		/*
		 * if (ab04b56s00 != null && ab04b56s00.getCnaeemp056() != null) {
		 * where.append(" AND UPPER(CNAEEMP) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(ab04b56s00.getCnaeemp056().toUpperCase() +
		 * "%"); } else { params.add("%" +
		 * ab04b56s00.getCnaeemp056().toUpperCase() + "%"); } where.append(
		 * " AND CNAEEMP IS NOT NULL"); }
		 */

		if (ab04b56s00 != null && ab04b56s00.getCnaeempDesde() != null) {
			where.append(" AND CNAEEMP >= ? ");
			params.add(Integer.valueOf(ab04b56s00.getCnaeempDesde()));
			where.append(" AND CNAEEMP IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaeempHasta() != null) {
			where.append(" AND CNAEEMP <= ? ");
			params.add(Integer.valueOf(ab04b56s00.getCnaeempHasta()));
			where.append(" AND CNAEEMP IS NOT NULL");
		}

		// direccion centro trabajo
		if (ab04b56s00 != null && ab04b56s00.getDirctr056() != null) {
			where.append(" AND UPPER(DIRCTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDirctr056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getDirctr056().toUpperCase() + "%");
			}
			where.append(" AND DIRCTR IS NOT NULL");
		}

		// numero total trabajadores (desde-hasta)
		if (ab04b56s00 != null && ab04b56s00.getTrbtot056() != null) {
			where.append(" AND TRBTOT = ?");
			params.add(ab04b56s00.getTrbtot056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbTotDesde() != null) {
			where.append(" AND TRBTOT >= ?");
			params.add(ab04b56s00.getTrbTotDesde());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbTotHasta() != null) {
			where.append(" AND TRBTOT <= ?");
			params.add(ab04b56s00.getTrbTotHasta());
		}

		// fecha cierre
		if (ab04b56s00 != null && ab04b56s00.getEstadoComunicacion() != null) {
			if (ab04b56s00.getEstadoComunicacion()
					.equals(Constantes.ESTADO_ABIERTO)) {
				where.append(" AND FECIER IS NULL ");
			} else if (ab04b56s00.getEstadoComunicacion()
					.equals(Constantes.ESTADO_CERRADO)) {
				where.append(" AND FECIER IS NOT NULL ");
			}
		}

		// estado
		if (ab04b56s00 != null && ab04b56s00.getEstado056() != null
				&& !"T".equals(ab04b56s00.getEstado056())) {
			where.append(" AND UPPER(ESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getEstado056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getEstado056().toUpperCase() + "%");
			}
			where.append(" AND ESTADO IS NOT NULL");
		}

		// estado cierre
		if (ab04b56s00 != null && ab04b56s00.getEstadocier056() != null) {

			if (Constantes.ESTADO_ELIMINADO
					.equals(ab04b56s00.getEstadocier056())) {
				where.append(" AND ESTADO = 'E' ");
			} else {
				where.append(" AND UPPER(ESTADOCIER) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(
							ab04b56s00.getEstadocier056().toUpperCase() + "%");
				} else {
					params.add("%" + ab04b56s00.getEstadocier056().toUpperCase()
							+ "%");
				}
				where.append(" AND ESTADOCIER IS NOT NULL");
			}
		}

		// tipo de cambio
		if (ab04b56s00 != null && ab04b56s00.getTipoCambio() != null) {
			where.append(
					" AND EXISTS(select tipocambio_087 from AB0487S00 where idape_087=COMUNIC_APE.IDAPE and tipocambio_087=?) ");
			params.add(ab04b56s00.getTipoCambio().toUpperCase());

		}

		// fecha modificacion
		if (ab04b56s00 != null && ab04b56s00.getFecmod056() != null) {
			where.append(" AND FECMOD = ?");
			params.add(ab04b56s00.getFecmod056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecmodifDesde() != null) {
			where.append(" AND TRUNC(FECMOD) >= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecmodifDesdeStr());
			params.add(mascara);
		}
		if (ab04b56s00 != null && ab04b56s00.getFecmodifHasta() != null) {
			where.append(" AND TRUNC(FECMOD) <= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecmodifHastaStr());
			params.add(mascara);
		}

		// estado visita osalan
		if (ab04b56s00 != null && ab04b56s00.getVisosl056() != null) {
			where.append(" AND UPPER(VISOSL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getVisosl056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getVisosl056().toUpperCase() + "%");
			}
			where.append(" AND VISOSL IS NOT NULL");
		}

		// tiene informe osalan
		if (ab04b56s00 != null && ab04b56s00.getFinfosl056() != null) {
			where.append(" AND FINFOSL = ?");
			params.add(ab04b56s00.getFinfosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIndInfOsalan() != null) {
			if (Constantes.VALUE_SI.equals(ab04b56s00.getIndInfOsalan())) {
				where.append(" AND FINFOSL IS NOT NULL");
			} else if (Constantes.VALUE_NO
					.equals(ab04b56s00.getIndInfOsalan())) {
				where.append(" AND FINFOSL IS NULL");
			}
		}

		// tiene informe inspeccion
		if (ab04b56s00 != null && ab04b56s00.getFinfinsp056() != null) {
			where.append(" AND FINFINSP = ?");
			params.add(ab04b56s00.getFinfinsp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIndInfInsp() != null) {
			if (Constantes.VALUE_SI.equals(ab04b56s00.getIndInfInsp())) {
				where.append(" AND FINFINSP IS NOT NULL");
			} else if (Constantes.VALUE_NO.equals(ab04b56s00.getIndInfInsp())) {
				where.append(" AND FINFINSP IS NULL");
			}
		}

		// motivo baja
		if (ab04b56s00 != null && ab04b56s00.getMotivoBaja() != null) {
			where.append(
					" AND EXISTS( SELECT '1' from AB0487S00 WHERE tipocambio_087 = 'EL' AND idape_087=COMUNIC_APE.IDAPE AND UPPER(SUBSTR(REGMIDIFICACIONES_087 , instr(REGMIDIFICACIONES_087, 'motivoEliminacion')+18)) like ? ESCAPE  '\\') ");
			if (startsWith) {
				params.add(ab04b56s00.getMotivoBaja().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getMotivoBaja().toUpperCase() + "%");
			}
		}
		if (ab04b56s00 != null && ab04b56s00.getDatosNotificacion() != null
				&& ab04b56s00.getDatosNotificacion()
						.getCodDatosNotif066() != null) {
			where.append(" AND CODDATOSNOTIF056 = ?");
			params.add(ab04b56s00.getDatosNotificacion().getCodDatosNotif066());
		}

		// Tiene plan de seguridad
		if (ab04b56s00 != null && ab04b56s00.getPlanseg056() != null) {
			where.append(" AND UPPER(PLANSEG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getPlanseg056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getPlanseg056().toUpperCase() + "%");
			}
			where.append(" AND PLANSEG IS NOT NULL");
		}

		// Tiene proyecto tecnico
		if (ab04b56s00 != null && ab04b56s00.getProytec056() != null) {
			where.append(" AND UPPER(PROYTEC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getProytec056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getProytec056().toUpperCase() + "%");
			}
			where.append(" AND PROYTEC IS NOT NULL");
		}

		// Tiene proyecto tecnico
		if (ab04b56s00 != null && ab04b56s00.getIndanx056() != null) {
			where.append(" AND UPPER(INDANX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getIndanx056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getIndanx056().toUpperCase() + "%");
			}
			where.append(" AND INDANX IS NOT NULL");
		}

		// Pais empresa
		if (ab04b56s00 != null && ab04b56s00.getPaisemp056() != null) {
			where.append(" AND UPPER(PAISEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getPaisemp056() + "%");
			} else {
				params.add("%" + ab04b56s00.getPaisemp056() + "%");
			}
			where.append(" AND PAISEMP IS NOT NULL");
		}

		// Municipio empresa
		if (ab04b56s00 != null && ab04b56s00.getMunicipioEmp() != null
				&& ab04b56s00.getMunicipioEmp().getCodMunicipio() != null) {
			where.append(" AND UPPER(MUNEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						ab04b56s00.getMunicipioEmp().getCodMunicipio() + "%");
			} else {
				params.add("%" + ab04b56s00.getMunicipioEmp().getCodMunicipio()
						+ "%");
			}
			where.append(" AND MUNEMP IS NOT NULL");
		}

		// Territorio empresa
		if (ab04b56s00 != null && ab04b56s00.getProvinciaEmp() != null
				&& ab04b56s00.getProvinciaEmp().getCodProvincia() != null) {
			where.append(" AND UPPER(PRVEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						ab04b56s00.getProvinciaEmp().getCodProvincia() + "%");
			} else {
				params.add("%" + ab04b56s00.getProvinciaEmp().getCodProvincia()
						+ "%");
			}
			where.append(" AND PRVEMP IS NOT NULL");
		}

		if (ab04b56s00 != null && ab04b56s00.getTareasPendientes() != null) {

			where.append(
					" AND EXISTS(SELECT '1' FROM VTAREAS_TRAMITES_APERTURAS where ESTADO_063='0' and TIPO_090='S' AND NUM_APERTURA_062=numape AND TERRIT_APERTURA_062=terape AND ANO_APERTURA_062=anoape ");

			if (!ab04b56s00.getTareasPendientes().equals("all")) {
				where.append(" and task_id_090= ? ");
				params.add(ab04b56s00.getTareasPendientes());
			}
			where.append(" )");

		}
		// Envio inspeccion (Fecha envio inspeccion = null si envio = no)
		if (ab04b56s00 != null && ab04b56s00.getIndEnvio() != null
				&& !"".equals(ab04b56s00.getIndEnvio())
				&& "P".equals(ab04b56s00.getIndEnvio())) {
			/*
			 * StringBuilder whereEnvio = "P".equals(ab04b56s00.getIndEnvio()) ?
			 * new StringBuilder( " AND FECINSP IS NULL ") : new StringBuilder(
			 * " AND FECINSP IS NULL");
			 */

			where.append(" AND FECINSP IS NULL ");
		}

		// Si el usuario no tiene perfil de tramitador, no se muestran las
		// aperturas que estén en proceso de alta,
		// ya que en estas sólo se puede entrar en modo alta, y sólo pueden
		// hacerlo los tramitadores.
		if (ab04b56s00.isOcultarEnProcesoAlta()) {

			where.append(
					"  AND ((MIGRADO = 'N' AND FOLDERID IS NOT NULL) OR (MIGRADO = 'S')) ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b56s00 entity.
	 * 
	 * ab04b56s00 Ab04b56s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the vista where like map etiquetas
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getVistaWhereLikeMapEtiquetas(
			ComunicacionApertura ab04b56s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ComunicacionAperturaCustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// territorio
		if (ab04b56s00 != null && ab04b56s00.getTerape056() != null) {
			where.append(" AND UPPER(t1.TERAPE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTerape056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTerape056().toUpperCase() + "%");
			}
			where.append(" AND t1.TERAPE_056 IS NOT NULL");
		}

		// año
		if (ab04b56s00 != null && ab04b56s00.getAnoape056() != null) {
			where.append(" AND UPPER(t1.ANOAPE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getAnoape056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getAnoape056().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOAPE_056 IS NOT NULL");
		}

		// num expediente
		if (ab04b56s00 != null && ab04b56s00.getNumape056() != null) {
			where.append(" AND t1.NUMAPE_056 = ?");
			params.add(ab04b56s00.getNumape056());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findListadoAnualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(*) AS NUMAPERTURAS ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Long total = this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());

		query = new StringBuilder("SELECT TO_CHAR(FECPRE,'MM') as MES, ");
		query.append(" TERAPE, COUNT(*) AS NUMAPERTURAS ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		mapaWhere = this.getVistaWhereLikeMap(filtro, startsWith);

		where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY TO_CHAR(FECPRE,'MM'), TERAPE ");

		params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		List<ComunicacionApertura> listado = this.getJdbcTemplate().query(
				query.toString(), this.rwMapListadoMeses, params.toArray());

		for (int i = 0; i < listado.size(); i++) {
			ComunicacionApertura ca = listado.get(i);
			double porcentaje = Double.parseDouble(ca.getNumAperturas())
					/ Double.parseDouble(total.toString())
					* ConstantesNum.NUM_10000;
			int valor = Double.valueOf(porcentaje).intValue();
			porcentaje = Double.parseDouble(String.valueOf(valor))
					/ ConstantesNum.NUM_100;
			ca.setPorcentaje(Double.toString(porcentaje));
			listado.set(i, ca);
		}

		return listado;
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findListadoAnualMesTerCount(ComunicacionApertura filtro,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM (");
		query.append("SELECT TO_CHAR(FECPRE,'MM') as MES, TERAPE ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1  AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY TO_CHAR(FECPRE,'MM'), TERAPE )");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findListadoBianualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// ANYO
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(*) AS NUMAPERTURAS ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Long total = this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());

		query = new StringBuilder("SELECT TO_CHAR(FECPRE,'MM') as MES, ");
		query.append(" TERAPE, COUNT(*) AS NUMAPERTURAS ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		mapaWhere = this.getVistaWhereLikeMap(filtro, startsWith);

		where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY TO_CHAR(FECPRE,'MM'), TERAPE ");

		if (jqGridRequestDto != null && jqGridRequestDto.getSidx() != null) {
			query.append(" ORDER BY ").append(jqGridRequestDto.getSidx())
					.append(" ").append(jqGridRequestDto.getSord());
		}

		params = (List<?>) mapaWhere.get("params");

		// if (jqGridRequestDto != null) {
		// query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		// }

		List<ComunicacionApertura> listado = this.getJdbcTemplate().query(
				query.toString(), this.rwMapListadoMeses, params.toArray());

		// ANYO ANTERIOR
		filtro.setAnoape056(
				Integer.toString((Integer.valueOf(filtro.getAnoape056()) - 1)));

		query = new StringBuilder("SELECT COUNT(*) AS NUMAPERTURAS ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		mapaWhere = this.getVistaWhereLikeMap(filtro, startsWith);

		where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		params = (List<?>) mapaWhere.get("params");

		Long totalAnt = this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());

		query = new StringBuilder("SELECT TO_CHAR(FECPRE,'MM') as MES, ");
		query.append(" TERAPE, COUNT(*) AS NUMAPERTURAS ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		mapaWhere = this.getVistaWhereLikeMap(filtro, startsWith);

		where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY TO_CHAR(FECPRE,'MM'), TERAPE ");

		if (jqGridRequestDto != null && jqGridRequestDto.getSidx() != null) {
			query.append(" ORDER BY ").append(jqGridRequestDto.getSidx())
					.append(" ").append(jqGridRequestDto.getSord());
		}

		params = (List<?>) mapaWhere.get("params");

		// if (jqGridRequestDto != null) {
		// query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		// }

		List<ComunicacionApertura> listadoAnt = this.getJdbcTemplate().query(
				query.toString(), this.rwMapListadoMeses, params.toArray());

		// Montamos el listado final con los datos del anyo y del anyo anterior
		List<ComunicacionApertura> listadoFinal = new ArrayList<ComunicacionApertura>();

		for (int i = 1; i <= ConstantesNum.NUM_12; i++) {

			String strMes = Utilities.getInstance().strMonth(i);
			double porcentaje = 0;
			int valor = 0;
			String territorio = "";

			// Araba
			if (filtro.getTerape056() == null
					|| filtro.getTerape056().equals(Constantes.TH_ALAVA)) {
				ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
				comunicacionApertura.setMes(strMes);
				comunicacionApertura.setNumAperturas("0");
				comunicacionApertura.setNumAperturasAnt("0");
				territorio = Constantes.TH_ALAVA;
				comunicacionApertura.setTerapeDesc(
						Utilities.getInstance().strTerritorio(territorio));

				// Aperturas anyo
				for (int j = 0; j < listado.size(); j++) {
					String mes = listado.get(j).getMes();
					String terr = listado.get(j).getTerape056();

					if (strMes.equals(mes)
							&& terr.equals(Constantes.TH_ALAVA)) {
						comunicacionApertura.setNumAperturas(
								listado.get(j).getNumAperturas());
					}
				}
				// Aperturas anyo anterior
				for (int j = 0; j < listadoAnt.size(); j++) {
					String mes = listadoAnt.get(j).getMes();
					String terr = listadoAnt.get(j).getTerape056();

					if (strMes.equals(mes)
							&& terr.equals(Constantes.TH_ALAVA)) {
						comunicacionApertura.setNumAperturasAnt(
								listadoAnt.get(j).getNumAperturas());
					}
				}
				// Porcentaje
				porcentaje = 0;
				if (!"0".equals(total)) {
					porcentaje = Double
							.parseDouble(comunicacionApertura.getNumAperturas())
							/ Double.parseDouble(total.toString())
							* ConstantesNum.NUM_10000;
				}
				valor = Double.valueOf(porcentaje).intValue();
				porcentaje = Double.parseDouble(String.valueOf(valor))
						/ ConstantesNum.NUM_100;
				comunicacionApertura.setPorcentaje(Double.toString(porcentaje));
				// Porcentaje anyo anterior
				porcentaje = 0;
				if (!"0".equals(totalAnt)) {
					porcentaje = Double.parseDouble(
							comunicacionApertura.getNumAperturasAnt())
							/ Double.parseDouble(totalAnt.toString())
							* ConstantesNum.NUM_10000;
				}
				valor = Double.valueOf(porcentaje).intValue();
				porcentaje = Double.parseDouble(String.valueOf(valor))
						/ ConstantesNum.NUM_100;
				comunicacionApertura
						.setPorcentajeAnt(Double.toString(porcentaje));

				listadoFinal.add(comunicacionApertura);
			}

			// Gipuzkoa
			if (filtro.getTerape056() == null
					|| filtro.getTerape056().equals(Constantes.TH_GIPUZKOA)) {
				ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
				comunicacionApertura.setMes(strMes);
				comunicacionApertura.setNumAperturas("0");
				comunicacionApertura.setNumAperturasAnt("0");
				territorio = Constantes.TH_GIPUZKOA;
				comunicacionApertura.setTerapeDesc(
						Utilities.getInstance().strTerritorio(territorio));

				// Aperturas anyo
				for (int j = 0; j < listado.size(); j++) {
					String mes = listado.get(j).getMes();
					String terr = listado.get(j).getTerape056();

					if (strMes.equals(mes)
							&& terr.equals(Constantes.TH_GIPUZKOA)) {
						comunicacionApertura.setNumAperturas(
								listado.get(j).getNumAperturas());
					}
				}
				// Aperturas anyo anterior
				for (int j = 0; j < listadoAnt.size(); j++) {
					String mes = listadoAnt.get(j).getMes();
					String terr = listadoAnt.get(j).getTerape056();

					if (strMes.equals(mes)
							&& terr.equals(Constantes.TH_GIPUZKOA)) {
						comunicacionApertura.setNumAperturasAnt(
								listadoAnt.get(j).getNumAperturas());
					}
				}
				// Porcentaje
				porcentaje = 0;
				if (!"0".equals(total)) {
					porcentaje = Double
							.parseDouble(comunicacionApertura.getNumAperturas())
							/ Double.parseDouble(total.toString())
							* ConstantesNum.NUM_10000;
				}
				valor = Double.valueOf(porcentaje).intValue();
				porcentaje = Double.parseDouble(String.valueOf(valor))
						/ ConstantesNum.NUM_100;
				comunicacionApertura.setPorcentaje(Double.toString(porcentaje));
				// Porcentaje anyo anterior
				porcentaje = 0;
				if (!"0".equals(totalAnt)) {
					porcentaje = Double.parseDouble(
							comunicacionApertura.getNumAperturasAnt())
							/ Double.parseDouble(totalAnt.toString())
							* ConstantesNum.NUM_10000;
				}
				valor = Double.valueOf(porcentaje).intValue();
				porcentaje = Double.parseDouble(String.valueOf(valor))
						/ ConstantesNum.NUM_100;
				comunicacionApertura
						.setPorcentajeAnt(Double.toString(porcentaje));

				listadoFinal.add(comunicacionApertura);
			}

			// Bizkaia
			if (filtro.getTerape056() == null
					|| filtro.getTerape056().equals(Constantes.TH_BIZKAIA)) {
				ComunicacionApertura comunicacionApertura = new ComunicacionApertura();
				comunicacionApertura.setMes(strMes);
				comunicacionApertura.setNumAperturas("0");
				comunicacionApertura.setNumAperturasAnt("0");
				territorio = Constantes.TH_BIZKAIA;
				comunicacionApertura.setTerapeDesc(
						Utilities.getInstance().strTerritorio(territorio));

				// Aperturas anyo
				for (int j = 0; j < listado.size(); j++) {
					String mes = listado.get(j).getMes();
					String terr = listado.get(j).getTerape056();

					if (strMes.equals(mes)
							&& terr.equals(Constantes.TH_BIZKAIA)) {
						comunicacionApertura.setNumAperturas(
								listado.get(j).getNumAperturas());
					}
				}
				// Aperturas anyo anterior
				for (int j = 0; j < listadoAnt.size(); j++) {
					String mes = listadoAnt.get(j).getMes();
					String terr = listadoAnt.get(j).getTerape056();

					if (strMes.equals(mes)
							&& terr.equals(Constantes.TH_BIZKAIA)) {
						comunicacionApertura.setNumAperturasAnt(
								listadoAnt.get(j).getNumAperturas());
					}
				}
				// Porcentaje
				porcentaje = 0;
				if (!"0".equals(total)) {
					porcentaje = Double
							.parseDouble(comunicacionApertura.getNumAperturas())
							/ Double.parseDouble(total.toString())
							* ConstantesNum.NUM_10000;
				}
				valor = Double.valueOf(porcentaje).intValue();
				porcentaje = Double.parseDouble(String.valueOf(valor))
						/ ConstantesNum.NUM_100;
				comunicacionApertura.setPorcentaje(Double.toString(porcentaje));
				// Porcentaje anyo anterior
				porcentaje = 0;
				if (!"0".equals(totalAnt)) {
					porcentaje = Double.parseDouble(
							comunicacionApertura.getNumAperturasAnt())
							/ Double.parseDouble(totalAnt.toString())
							* ConstantesNum.NUM_10000;
				}
				valor = Double.valueOf(porcentaje).intValue();
				porcentaje = Double.parseDouble(String.valueOf(valor))
						/ ConstantesNum.NUM_100;
				comunicacionApertura
						.setPorcentajeAnt(Double.toString(porcentaje));

				listadoFinal.add(comunicacionApertura);
			}
		}

		// Paginacion
		if (jqGridRequestDto != null && jqGridRequestDto.getRows() != null) {
			List<ComunicacionApertura> listadoFinalPaginado = new ArrayList<ComunicacionApertura>();

			Long rows = jqGridRequestDto.getRows();
			Long page = jqGridRequestDto.getPage();

			int inicio = rows.intValue() * (page.intValue() - 1);
			int fin = rows.intValue() * page.intValue();

			for (int k = inicio; k < fin; k++) {
				if (k < listadoFinal.size()) {
					listadoFinalPaginado.add(listadoFinal.get(k));
				}
			}
			return listadoFinalPaginado;
		} else {
			return listadoFinal;
		}
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findListadoAnualSecTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(*) AS NUMAPERTURAS ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Long total = this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());

		query = new StringBuilder(
				"SELECT SECC_003 SECTOR, DESC_004 SECTORDESC, TERAPE, COUNT(*) AS NUMAPERTURAS ");

		if (filtro.getAgrupacion() != null && filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_CTR)) {
			query.append(
					", DIVI_003 || GRUP_003 || CLAS_003 AS CNAECTR, NULL AS CNAEEMP ");
		} else if (filtro.getAgrupacion() != null && filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_EMP)) {
			query.append(
					", NULL AS CNAECTR, DIVI_003 || GRUP_003 || CLAS_003 AS CNAEEMP ");
		} else {
			query.append(", NULL AS CNAECTR, NULL AS CNAEEMP ");
		}

		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		query.append(" , J7303S00, J7304S00 ");

		// Where clause & Params
		mapaWhere = this.getVistaWhereLikeMap(filtro, startsWith);

		where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));

		if (filtro.getAgrupacion() != null && filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_CTR)) {
			where.append(
					" AND CNAECTR = DIVI_003 || GRUP_003 || CLAS_003 AND SECC_003 = SECC_004 ");
		} else {
			where.append(
					" AND CNAEEMP = DIVI_003 || GRUP_003 || CLAS_003 AND SECC_003 = SECC_004 ");
		}

		query.append(where);

		if (filtro.getAgrupacion() != null && (filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_CTR)
				|| filtro.getAgrupacion()
						.equals(Constantes.AGRUPACION_CNAE_EMP))) {
			query.append(
					" GROUP BY SECC_003, DESC_004, TERAPE, DIVI_003 || GRUP_003 || CLAS_003 ");
		} else {
			query.append(" GROUP BY SECC_003, DESC_004, TERAPE ");
		}

		params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		List<ComunicacionApertura> listado = this.getJdbcTemplate().query(
				query.toString(), this.rwMapListadoSectores, params.toArray());

		for (int i = 0; i < listado.size(); i++) {
			ComunicacionApertura ca = listado.get(i);
			double porcentaje = Double.parseDouble(ca.getNumAperturas())
					/ Double.parseDouble(total.toString())
					* ConstantesNum.NUM_10000;
			int valor = Double.valueOf(porcentaje).intValue();
			porcentaje = Double.parseDouble(String.valueOf(valor))
					/ ConstantesNum.NUM_100;
			ca.setPorcentaje(Double.toString(porcentaje));
			listado.set(i, ca);
		}

		return listado;
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findListadoAnualSecTerCount(ComunicacionApertura filtro,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM (");
		query.append(
				"SELECT SECC_003 SECTOR, DESC_004 SECTORDESC, TERAPE, COUNT(*) AS NUMAPERTURAS ");

		if (filtro.getAgrupacion() != null && filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_CTR)) {
			query.append(
					", DIVI_003 || GRUP_003 || CLAS_003 AS CNAECTR, NULL AS CNAEEMP ");
		} else if (filtro.getAgrupacion() != null && filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_EMP)) {
			query.append(
					", NULL AS CNAECTR, DIVI_003 || GRUP_003 || CLAS_003 AS CNAEEMP ");
		} else {
			query.append(", NULL AS CNAECTR, NULL AS CNAEEMP ");
		}

		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		query.append(" , J7303S00, J7304S00 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));

		if (filtro.getAgrupacion() != null && filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_CTR)) {
			where.append(
					" AND CNAECTR = DIVI_003 || GRUP_003 || CLAS_003 AND SECC_003 = SECC_004 ");
		} else {
			where.append(
					" AND CNAEEMP = DIVI_003 || GRUP_003 || CLAS_003 AND SECC_003 = SECC_004 ");
		}

		query.append(where);

		if (filtro.getAgrupacion() != null && (filtro.getAgrupacion()
				.equals(Constantes.AGRUPACION_CNAE_CTR)
				|| filtro.getAgrupacion()
						.equals(Constantes.AGRUPACION_CNAE_EMP))) {
			query.append(
					" GROUP BY SECC_003, DESC_004, TERAPE, DIVI_003 || GRUP_003 || CLAS_003 )");
		} else {
			query.append(" GROUP BY SECC_003, DESC_004, TERAPE )");
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findNumberAperturaTrab(
			ComunicacionApertura filtro, Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT(*) AS RESULT ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Long total = this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
		List<ComunicacionApertura> results = new ArrayList<ComunicacionApertura>();

		// No se citan
		String whereAniadido = " AND (TRBTOT IS NULL OR TRBTOT = 0) ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.NO_SE_CITAN, startsWith));

		// De 1 a 5
		whereAniadido = " AND TRBTOT >= 1 AND TRBTOT <= 5 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE1A5, startsWith));

		// De 6 a 10
		whereAniadido = " AND TRBTOT >= 6 AND TRBTOT <= 10 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE6A10, startsWith));

		// De 11 a 15
		whereAniadido = " AND TRBTOT >= 11 AND TRBTOT <= 15 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE11A15, startsWith));

		// De 16 a 20
		whereAniadido = " AND TRBTOT >= 16 AND TRBTOT <= 20 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE16A20, startsWith));

		// De 21 a 25
		whereAniadido = " AND TRBTOT >= 21 AND TRBTOT <= 25 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE21A25, startsWith));

		// De 26 a 30
		whereAniadido = " AND TRBTOT >= 26 AND TRBTOT <= 30 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE26A30, startsWith));

		// De 31 a 35
		whereAniadido = " AND TRBTOT >= 31 AND TRBTOT <= 35 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE31A35, startsWith));

		// De 36 a 40
		whereAniadido = " AND TRBTOT >= 36 AND TRBTOT <= 40 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE36A40, startsWith));

		// De 41 a 45
		whereAniadido = " AND TRBTOT >= 41 AND TRBTOT <= 45 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE41A45, startsWith));

		// De 46 a 50
		whereAniadido = " AND TRBTOT >= 46 AND TRBTOT <= 50 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.DE46A50, startsWith));

		// // Más de 50
		whereAniadido = " AND TRBTOT > 50 ";
		results.add(queryListadoTramosTrab(filtro, whereAniadido, total,
				Constantes.MASDE50, startsWith));

		return results;
	}

	/**
	 * Ejecuta la select para el listado de tramos de trabajadores.
	 * 
	 * filtro ComunicacionApertura whereAnadido String periodo String orden
	 * String List<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param whereAnadido
	 *            the where anadido
	 * @param total
	 *            the total
	 * @param tipoPart
	 *            the tipo part
	 * @param startsWith
	 *            the startsWith
	 * @return the string
	 */
	private ComunicacionApertura queryListadoTramosTrab(
			ComunicacionApertura filtro, String whereAnadido, Long total,
			String tipoPart, Boolean startsWith) {
		StringBuilder query = new StringBuilder();
		ComunicacionApertura instance = new ComunicacionApertura();

		query = new StringBuilder("SELECT COUNT(*) AS RESULT ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(whereAnadido);
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Long resultado = this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());

		instance = new ComunicacionApertura();

		instance.setNumAperturas(resultado.toString());

		instance.setPorcentaje(this.calcularPorcentaje(total, resultado));

		instance.setTipoPart(tipoPart);
		return instance;
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<ComunicacionApertura> findNumberAperturaTrabPorCentro(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				"SELECT SUM(COUNT(1)) AS RESULT ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);
		query.append(
				" LEFT OUTER JOIN AB0472S00 T72 ON (COMUNIC_APE.CLASCTR=T72.CLASCTR_072) ");
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND TRBTOT IS NOT NULL AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY CLASCTR, T72.DESCLAS_ES_072, TERAPE");

		List<?> params = (List<?>) mapaWhere.get("params");

		Long total = this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
		List<ComunicacionApertura> results = new ArrayList<ComunicacionApertura>();

		// No se citan
		query = new StringBuilder(
				"SELECT TERAPE, CLASCTR, T72.DESCLAS_ES_072 AS DESCCLASCTR, COUNT(*) AS RESULT ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		mapaWhere = this.getVistaWhereLikeMap(filtro, startsWith);
		query.append(
				" LEFT OUTER JOIN AB0472S00 T72 ON (COMUNIC_APE.CLASCTR=T72.CLASCTR_072) ");
		where = new StringBuilder(
				" WHERE 1=1 AND TRBTOT IS NOT NULL AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY CLASCTR, T72.DESCLAS_ES_072, TERAPE");

		params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		List<ComunicacionApertura> listado = this.getJdbcTemplate().query(
				query.toString(), this.rwMapListadoTramosPorCentro,
				params.toArray());

		ComunicacionApertura instance = new ComunicacionApertura();

		for (ComunicacionApertura apertura : listado) {
			instance = new ComunicacionApertura();

			if (apertura.getDescTipoCtr() != null
					&& !apertura.getDescTipoCtr().equals("")) {
				instance.setDescTipoCtr(apertura.getDescTipoCtr());
			} else {
				instance.setDescTipoCtr("");
			}
			instance.setNumAperturas(apertura.getNumAperturas());
			double porcentaje = 0;
			if (!"0".equals(total)) {
				porcentaje = Double.parseDouble(instance.getNumAperturas())
						/ Double.parseDouble(total.toString())
						* ConstantesNum.NUM_10000;
			}
			int valor = Double.valueOf(porcentaje).intValue();
			porcentaje = Double.parseDouble(String.valueOf(valor))
					/ ConstantesNum.NUM_100;
			instance.setPorcentaje(Double.toString(porcentaje));

			instance.setTerapeDesc(apertura.getTerapeDesc());
			instance.setTerape056(apertura.getTerape056());

			results.add(instance);
		}
		return results;
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	public Long findNumberAperturaTrabPorCentroCount(
			ComunicacionApertura filtro, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM(SELECT 1 ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND TRBTOT IS NOT NULL AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY CLASCTR, TERAPE)");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Obtiene una lista con todos los numeros de apertura por por tramos de
	 * trabajador.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto List
	 * <ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<ComunicacionApertura> findNumberAperturaTrabPorTrabajadores(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto) {
		String whereAnadido = "";
		StringBuilder query = new StringBuilder(
				"SELECT ANOAPE, NUMMES, RESULT, TERAPE, TIPOPART, ORDEN FROM (");

		// No se citan
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT IS NULL OR TRBTOT = 0 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM IS NULL OR TRBHOM = 0 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ IS NULL OR TRBMUJ = 0 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.NO_SE_CITAN, "1"));

		query.append(" UNION ");

		// De 1 a 5
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 1 AND TRBTOT <= 5 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 1 AND TRBHOM <= 5 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 1 AND TRBMUJ <= 5 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE1A5, "2"));

		query.append(" UNION ");

		// De 6 a 10
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 6 AND TRBTOT <= 10 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 6 AND TRBHOM <= 10 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 6 AND TRBMUJ <= 10 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE6A10, "3"));

		query.append(" UNION ");

		// De 11 a 15
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 11 AND TRBTOT <= 15 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 11 AND TRBHOM <= 15 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 11 AND TRBMUJ <= 15 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE11A15, "4"));

		query.append(" UNION ");

		// De 16 a 20
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 16 AND TRBTOT <= 20 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 16 AND TRBHOM <= 20 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 16 AND TRBMUJ <= 20 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE16A20, "5"));

		query.append(" UNION ");

		// De 21 a 25
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 21 AND TRBTOT <= 25 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 21 AND TRBHOM <= 25 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 21 AND TRBMUJ <= 25 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE21A25, "6"));

		query.append(" UNION ");

		// De 26 a 30
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 26 AND TRBTOT <= 30 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 26 AND TRBHOM <= 30 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 26 AND TRBMUJ <= 30 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE26A30, "7"));

		query.append(" UNION ");

		// De 31 a 35
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 31 AND TRBTOT <= 35 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 31 AND TRBHOM <= 35 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 31 AND TRBMUJ <= 35 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE31A35, "8"));

		query.append(" UNION ");

		// De 36 a 40
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 36 AND TRBTOT <= 40 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 36 AND TRBHOM <= 40 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 36 AND TRBMUJ <= 40 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE36A40, "9"));

		query.append(" UNION ");

		// De 41 a 45
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 41 AND TRBTOT <= 45 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 41 AND TRBHOM <= 45 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 41 AND TRBMUJ <= 45 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE41A45, "10"));

		query.append(" UNION ");

		// De 46 a 50
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 46 AND TRBTOT <= 50 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 46 AND TRBHOM <= 50 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 46 AND TRBMUJ <= 50 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE46A50, "11"));

		query.append(" UNION ");

		// Más de 50
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT > 50 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM > 50 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ > 50 ";
		}

		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.MASDE50, "12"));

		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro, false);

		StringBuilder where2 = new StringBuilder(") WHERE 1=1 ");
		where2.append(mapaWhere.get("query"));
		query.append(where2);
		List<?> params = (List<?>) mapaWhere.get("params");
		query.append(" ORDER BY NUMMES, ORDEN");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return this.getJdbcTemplate().query(query.toString(),
				this.rwMapListadoTramosTrabajadores, params.toArray());
	}

	/**
	 * Obtiene una lista con todos los numeros de apertura por por tramos de
	 * trabajador.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto List
	 * <ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	public Long findNumberAperturaTrabPorTrabajadoresCount(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto) {
		String whereAnadido = "";
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM (");

		// No se citan
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT IS NULL ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM IS NULL ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ IS NULL ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.NO_SE_CITAN, "1"));

		query.append(" UNION ");

		// De 1 a 5
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 1 AND TRBTOT <= 5 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 1 AND TRBHOM <= 5 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 1 AND TRBMUJ <= 5 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE1A5, "2"));

		query.append(" UNION ");

		// De 6 a 10
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 6 AND TRBTOT <= 10 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 6 AND TRBHOM <= 10 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 6 AND TRBMUJ <= 10 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE6A10, "3"));

		query.append(" UNION ");

		// De 11 a 15
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 11 AND TRBTOT <= 15 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 11 AND TRBHOM <= 15 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 11 AND TRBMUJ <= 15 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE11A15, "4"));

		query.append(" UNION ");

		// De 16 a 20
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 16 AND TRBTOT <= 20 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 16 AND TRBHOM <= 20 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 16 AND TRBMUJ <= 20 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE16A20, "5"));

		query.append(" UNION ");

		// De 21 a 25
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 21 AND TRBTOT <= 25 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 21 AND TRBHOM <= 25 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 21 AND TRBMUJ <= 25 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE21A25, "6"));

		query.append(" UNION ");

		// De 26 a 30
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 26 AND TRBTOT <= 30 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 26 AND TRBHOM <= 30 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 26 AND TRBMUJ <= 30 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE26A30, "7"));

		query.append(" UNION ");

		// De 31 a 35
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 31 AND TRBTOT <= 35 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 31 AND TRBHOM <= 35 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 31 AND TRBMUJ <= 35 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE31A35, "8"));

		query.append(" UNION ");

		// De 36 a 40
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 36 AND TRBTOT <= 40 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 36 AND TRBHOM <= 40 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 36 AND TRBMUJ <= 40 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE36A40, "9"));

		query.append(" UNION ");

		// De 41 a 45
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 41 AND TRBTOT <= 45 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 41 AND TRBHOM <= 45 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 41 AND TRBMUJ <= 45 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE41A45, "10"));

		query.append(" UNION ");

		// De 46 a 50
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT >= 46 AND TRBTOT <= 50 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM >= 46 AND TRBHOM <= 50 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ >= 46 AND TRBMUJ <= 50 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.DE46A50, "11"));

		query.append(" UNION ");

		// Más de 50
		if ("total".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBTOT > 50 ";
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBHOM > 50 ";
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			whereAnadido = " AND TRBMUJ > 50 ";
		}
		query.append(queryListadoTramosTrabPorTrab(filtro, whereAnadido,
				Constantes.MASDE50, "12"));

		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro, false);

		StringBuilder where2 = new StringBuilder(") WHERE 1=1 ");
		where2.append(mapaWhere.get("query"));
		query.append(where2);
		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Ejecuta la select para el listado de tramos de trabajadores.
	 * 
	 * filtro ComunicacionApertura whereAnadido String periodo String orden
	 * String List<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param whereAnadido
	 *            the where anadido
	 * @param periodo
	 *            the periodo
	 * @param orden
	 *            the orden
	 * @return the string
	 */
	private String queryListadoTramosTrabPorTrab(ComunicacionApertura filtro,
			String whereAnadido, String periodo, String orden) {
		StringBuilder query = new StringBuilder();

		StringBuilder select = new StringBuilder(
				"SELECT ANOAPE, TO_CHAR( FECPRE,'MM') AS NUMMES, COUNT(1) AS RESULT, TERAPE, '"
						+ periodo + "' AS TIPOPART, " + orden + " AS ORDEN ");
		query = new StringBuilder(select);
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		if ("total".equals(filtro.getAgrupacion())) {
			where.append(whereAnadido);
		} else if ("hombres".equals(filtro.getAgrupacion())) {
			where.append(whereAnadido);
		} else if ("mujeres".equals(filtro.getAgrupacion())) {
			where.append(whereAnadido);
		}
		query.append(where);

		query.append(" GROUP BY ANOAPE, TO_CHAR( FECPRE,'MM'), TERAPE ");

		return query.toString();
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findListadoSinInfoOsalan(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				"SELECT TERAPE, ANOAPE, NUMAPE, FECPRE, NUMDOC, NOMEMP, PRVCTR, DESPRVCTR, MUNCTR, DESMUNCTR, DIRCTR, ");
		query.append(
				" VISOSL, (SELECT DESCRIPCION_088 FROM AB0488S00 WHERE CODTABLA_088='"
						+ Constantes.TABLON_ESTADO_VISITA_OSALAN
						+ "' AND CODIGO_088 = VISOSL) as DESCVISITA, ");
		query.append(
				" (SELECT DESCRIPCION_EUS_088 FROM AB0488S00 WHERE CODTABLA_088='"
						+ Constantes.TABLON_ESTADO_VISITA_OSALAN
						+ "' AND CODIGO_088 = VISOSL) as DESCVISITA_EU, FINFINSP ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" AND (VISOSL IS NULL OR FINFINSP IS NULL) ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return this.getJdbcTemplate().query(query.toString(),
				this.rwMapListadoOsalan, params.toArray());
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findListadoSinInfoOsalanCount(ComunicacionApertura filtro,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM (");
		query.append(
				"SELECT TERAPE, ANOAPE, NUMAPE, FECPRE, NUMDOC, NOMEMP, PRVCTR, DESPRVCTR, MUNCTR, DESMUNCTR, DIRCTR, ");
		query.append(
				" VISOSL, (SELECT DESCRIPCION_088 FROM AB0488S00 WHERE CODTABLA_088='"
						+ Constantes.TABLON_ESTADO_VISITA_OSALAN
						+ "' AND CODIGO_088 = VISOSL) as DESCVISITA, ");
		query.append(
				" (SELECT DESCRIPCION_EUS_088 FROM AB0488S00 WHERE CODTABLA_088='"
						+ Constantes.TABLON_ESTADO_VISITA_OSALAN
						+ "' AND CODIGO_088 = VISOSL) as DESCVISITA_EU, FINFINSP ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" AND (VISOSL IS NULL OR FINFINSP IS NULL)) ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findListadoSubsanacion(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				"SELECT TERAPE, ANOAPE, NUMAPE, FECPRE, NUMDOC, NOMEMP, NOMCTR, PRVCTR, DESPRVCTR, MUNCTR, DESMUNCTR, DIRCTR, FECREQ ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" AND FECREQ IS NOT NULL ");
		query.append(
				" AND (( FECSUB IS NOT NULL AND TO_DATE(FECSUB, 'dd-MM-yyyy') - TO_DATE(FECREQ, 'dd-MM-yyyy') > "
						+ Constantes.CONSTANTE_DATE_DIFF + ") ");
		query.append(
				" OR (FECSUB IS NULL AND TO_DATE(SYSDATE, 'dd-MM-yyyy') - TO_DATE(FECREQ, 'dd-MM-yyyy') > "
						+ Constantes.CONSTANTE_DATE_DIFF + ")) ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return this.getJdbcTemplate().query(query.toString(),
				this.rwMapListadoSubsanacion, params.toArray());
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findListadoSubsanacionCount(ComunicacionApertura filtro,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM (");
		query.append(
				"SELECT TERAPE, ANOAPE, NUMAPE, FECPRE, NUMDOC, NOMEMP, NOMCTR, PRVCTR, DESPRVCTR, MUNCTR, DESMUNCTR, DIRCTR, FECREQ ");
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_COMUNICACION_APERTURA);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMap(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND ESTADO IS NOT NULL AND FECPRE IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" AND FECREQ IS NOT NULL ");
		query.append(
				" AND (( FECSUB IS NOT NULL AND TO_DATE(FECSUB, 'dd-MM-yyyy') - TO_DATE(FECREQ, 'dd-MM-yyyy') > "
						+ Constantes.CONSTANTE_DATE_DIFF + ") ");
		query.append(
				" OR (FECSUB IS NULL AND TO_DATE(SYSDATE, 'dd-MM-yyyy') - TO_DATE(FECREQ, 'dd-MM-yyyy') > "
						+ Constantes.CONSTANTE_DATE_DIFF + ")) ");
		query.append(") ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * total Long resultado Long valor int String
	 * 
	 * @param total
	 *            the total
	 * @param resultado
	 *            the resultado
	 * @return the string
	 */
	private String calcularPorcentaje(Long total, Long resultado) {
		double porcentaje = 0;
		int valor;
		if (!"0".equals(total)) {
			porcentaje = Double.parseDouble(resultado.toString())
					/ Double.parseDouble(total.toString())
					* ConstantesNum.NUM_10000;
		}
		valor = Double.valueOf(porcentaje).intValue();
		porcentaje = Double.parseDouble(String.valueOf(valor))
				/ ConstantesNum.NUM_100;
		return Double.toString(porcentaje);
	}

	/**
	 * Devuelve los datos de notificacion de un expediente.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean ComunicacionApertura
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> obtenerDatosEtiquetas(
			ComunicacionApertura filtro, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaCustomDaoImpl.QUERY_SELECT_DATOS_ETIQUETAS);
		query.append(
				ComunicacionAperturaCustomDaoImpl.QUERY_FROM_DATOS_ETIQUETAS);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMapEtiquetas(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t2.CANALNOTIF_066 = 1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<ComunicacionApertura>) this.getJdbcTemplate().query(
				query.toString(), this.rwMapDatosEtiquetas, params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
